import 'package:flutter/material.dart';
import '../../../core/utils/dimensions.dart';
import '../../../core/utils/my_color.dart';
import '../../../core/utils/util.dart';

class BottomSheetCard extends StatelessWidget {

  final Widget child;
  final double  bottomSpace;
  final double padding;
  const BottomSheetCard({
    Key? key,
    required this.child,this.bottomSpace = Dimensions.space7,this.padding = Dimensions.space15}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
    padding: EdgeInsets.all(padding),
    margin:  EdgeInsetsDirectional.only(top: bottomSpace),
    decoration: BoxDecoration(
    borderRadius: BorderRadius.circular(Dimensions.defaultRadius),
    color: MyColor.colorWhite ,
    border: Border.all(width: .5,color: MyColor.primaryColor.withOpacity(.1)),
        boxShadow: MyUtils.getBottomSheetShadow()
    ),
    child: child);
  }
}
